import requests, json, sys
import subprocess
import BackhaulConfiguration
from Backhaul import Backhaul

# Messy -- not expecting to maintain it tbh

class BackhaulUnitTest(object):
    
    def __init__(self, serverCheck):
        self.backhaul = Backhaul("publicQueue", directReply=True)
        self.serverCheck = serverCheck

    def httpTestPort(self):
        port = BackhaulConfiguration.getRMQServerPort()
        port = port if port is not None else 8088
        url = 'http://127.0.0.1:{0}/queueRabbitMQ'.format(port)
        payload = {"Topic":"generic-test-topic", "Data":{"what":"abcde"}}
        headers = {'content-type': 'application/json'}

        if not self.serverCheck:
            print "Testing BackhaulServer on Port: " + str(port)
            print "URL: " + str(url)
            print "Payload: " + str(payload) + "\n"
            print

        try:
            x = requests.post(url, json = payload, headers=headers)
        except Exception as e:
            return False
            
        if x.text == "200":
            return True
        else:
            if not self.serverCheck:
                 print "Sending data via HTTP failed."
            return False

    def backhaulGenericTest(self, **kwargs):

        self.backhaul.directReply = kwargs.get("directReply", True)

        data = {}
        data['dummy'] = "data"
        data['number'] = 10101
        jsonData = json.dumps(data)
        result = self.backhaul.sendData("generic-test-topic", jsonData)
        self.backhaul.directReply = True #reset

        if result:
            return True
        else:
            return False

    def existingKeys(self):
        
        data = {}
        data[BackhaulConfiguration.getIDFormat()] = "Data1"
        data[BackhaulConfiguration.getLocalDateTimeFormat()] = "Data2"
        data[BackhaulConfiguration.getUTCDateTimeFormat()] = "Data3"
        data["Dummy"] = "Data4"
        data["DummyData"] = "Data3"
        
        result = self.backhaul.sendData("generic-test-topic", json.dumps(data), debug=True)
        print "Expected # of Keys: 5"
    
        if result:
            return True
        else:
            print "Existing keys test failed."
            return False

    def noExistingKeys(self):
        data = {}
        data[BackhaulConfiguration.getIDFormat()+"TEST"] = "Data1"
        data[BackhaulConfiguration.getLocalDateTimeFormat()+"TEST"] = "Data2"
        data[BackhaulConfiguration.getUTCDateTimeFormat()+"TEST"] = "Data3"

        result = self.backhaul.sendData("generic-test-topic", json.dumps(data), debug=True)
        print "Expected # of Keys: 6"

        if result:
            return True
        else:
            print "Default keys test failed."
            return False

    def jsonFormatTest(self):

        #Throw the file/text you want sent to Pulsar. Please keep note of the topic name

        port = BackhaulConfiguration.getRMQServerPort()
        port = port if port is not None else 8088
        url = 'http://127.0.0.1:{0}/queueRabbitMQ'.format(port)
        with open("/home/pi/Pulsar/jsonFormatTest.txt", "r") as f:
            payload = json.loads(f.read())
        headers = {'content-type': 'application/json'}

        x = requests.post(url, json = payload, headers=headers)
        
        print x.text

    def testSerial(self):

        print "!!! Please make sure it is valid."
        print "This device's serial is: ",
        return BackhaulConfiguration.getSerial()

if __name__ == '__main__':

    if len(sys.argv) > 1:
        if sys.argv[1] == "STATUS":
            test = BackhaulUnitTest(True)
            rabbitServeStatus = 1 if test.httpTestPort() else 0
            queueBackhaul = 1 if test.backhaulGenericTest(directReply=False) else 0
            resultString = "{0}|{1}".format(rabbitServeStatus, queueBackhaul)
            print resultString
    else:
        test = BackhaulUnitTest(False)
        print "========================================"
        print test.httpTestPort()
        print "========================================"
        print test.backhaulGenericTest()
        print "========================================"
        print test.existingKeys()
        print "========================================"
        print test.noExistingKeys()
        print "========================================"
        # print test.jsonFormatTest()
        print "========================================"
        print test.testSerial()

